/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.internal.recipeHandlers;

import craftedMods.lotr.recipes.api.utils.TriFunction;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.ItemStackSet;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.base.AbstractRecipeHandler;
import craftedMods.recipes.base.ShapelessRecipe;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lotr.common.item.LOTRItemFeatherDyed;
import lotr.common.item.LOTRItemHaradRobes;
import lotr.common.item.LOTRItemHobbitPipe;
import lotr.common.item.LOTRItemLeatherHat;
import lotr.common.item.LOTRItemPartyHat;
import lotr.common.item.LOTRItemPouch;
import lotr.common.recipe.LOTRRecipePoisonWeapon;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

@RegisteredHandler
public class CauldronRecipeHandler
extends AbstractRecipeHandler<ShapelessRecipe> {
    private final CauldronRecipeHandlerRenderer renderer = new CauldronRecipeHandlerRenderer();

    public CauldronRecipeHandler() {
        super("lotr.cauldron");
    }

    public String getDisplayName() {
        return Blocks.field_150383_bp.func_149732_F();
    }

    public Collection<ShapelessRecipe> getDynamicCraftingRecipes(ItemStack result) {
        ItemArmor armorItem;
        ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
        this.handleUndyedResultItem(LOTRItemPouch.class, result, LOTRItemPouch::isPouchDyed, this.getDefaultColorPermutations(result, LOTRItemPouch::setPouchColor), recipes);
        this.handleUndyedResultItem(LOTRItemHobbitPipe.class, result, stack -> LOTRItemHobbitPipe.getSmokeColor(stack) != 0, this.getHobbitPipeDyePermutations(result), recipes);
        this.handleUndyedResultItem(LOTRItemLeatherHat.class, result, ((Predicate<ItemStack>)LOTRItemLeatherHat::isHatDyed).or(LOTRItemLeatherHat::isFeatherDyed), this.getLeatherHatDyePermutations(result), recipes);
        this.handleUndyedResultItem(LOTRItemFeatherDyed.class, result, LOTRItemFeatherDyed::isFeatherDyed, this.getDefaultColorPermutations(result, LOTRItemFeatherDyed::setFeatherColor), recipes);
        this.handleUndyedResultItem(LOTRItemHaradRobes.class, result, LOTRItemHaradRobes::areRobesDyed, this.getDefaultColorPermutations(result, LOTRItemHaradRobes::setRobesColor), recipes);
        this.handleUndyedResultItem(LOTRItemPartyHat.class, result, LOTRItemPartyHat::isHatDyed, this.getDefaultColorPermutations(result, LOTRItemPartyHat::setHatColor), recipes);
        if (result.func_77973_b() instanceof ItemArmor && recipes.isEmpty() && (armorItem = (ItemArmor)result.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.CLOTH) {
            this.handleUndyedResultItem(ItemArmor.class, result, arg_0 -> ((ItemArmor)armorItem).func_82816_b_(arg_0), this.getDefaultColorPermutations(result, (arg_0, arg_1) -> ((ItemArmor)armorItem).func_82813_b(arg_0, arg_1)), recipes);
        }
        if (LOTRRecipePoisonWeapon.inputToPoisoned.containsKey(result.func_77973_b())) {
            ItemStack input = new ItemStack(LOTRRecipePoisonWeapon.inputToPoisoned.get(result.func_77973_b()));
            if (result.func_77984_f()) {
                input.func_77964_b(result.func_77960_j());
            }
            recipes.add(new ShapelessRecipe((Object)input, result));
        }
        return recipes;
    }

    private <T extends Item> void handleUndyedResultItem(Class<T> itemType, ItemStack result, Predicate<ItemStack> isDyedFunction, Function<ItemStack, Collection<ItemStack>> permutationsFunction, Collection<ShapelessRecipe> recipes) {
        if (itemType.isAssignableFrom(result.func_77973_b().getClass()) && !isDyedFunction.test(result)) {
            recipes.add(new UndyeningRecipe(permutationsFunction.apply(result.func_77946_l()), result));
        }
    }

    private Function<ItemStack, Collection<ItemStack>> getHobbitPipeDyePermutations(ItemStack result) {
        ArrayList<ItemStack> data = new ArrayList<ItemStack>();
        for (int i = 0; i < 16; ++i) {
            ItemStack dyedStack = result.func_77946_l();
            LOTRItemHobbitPipe.setSmokeColor(dyedStack, i + 1);
            data.add(dyedStack);
        }
        return stack -> data;
    }

    private Function<ItemStack, Collection<ItemStack>> getDefaultColorPermutations(ItemStack result, TriFunction<Integer, Integer, Integer, ItemStack> function) {
        ArrayList<ItemStack> data = new ArrayList<ItemStack>();
        for (int r = 0; r < 255; r += 25) {
            for (int g = 0; g < 255; g += 25) {
                for (int b = 0; b < 255; b += 25) {
                    if (r >= 255 || g >= 255 || b >= 255) continue;
                    data.add(function.accept(r, g, b));
                }
            }
        }
        return stack -> data;
    }

    private Function<ItemStack, Collection<ItemStack>> getDefaultColorPermutations(ItemStack result, BiConsumer<ItemStack, Integer> dyeFunction) {
        return this.getDefaultColorPermutations(result, (Integer r, Integer g, Integer b) -> {
            ItemStack dyedStack = result.func_77946_l();
            dyeFunction.accept(dyedStack, new Color((int)r, (int)g, (int)b, 0).getRGB());
            return dyedStack;
        });
    }

    private Function<ItemStack, Collection<ItemStack>> getLeatherHatDyePermutations(ItemStack result) {
        return this.getDefaultColorPermutations(result, (ItemStack stack, Integer colorInt) -> {
            Color color = new Color((int)colorInt);
            LOTRItemLeatherHat.setFeatherColor(stack, colorInt);
            LOTRItemLeatherHat.setHatColor(stack, new Color(color.getGreen(), color.getRed(), color.getBlue()).getRGB());
        });
    }

    public Collection<ShapelessRecipe> getDynamicUsageRecipes(ItemStack ingredient) {
        ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
        this.handleDyeableIngredientItem(LOTRItemPouch.class, ingredient, LOTRItemPouch::isPouchDyed, LOTRItemPouch::removePouchDye, recipes);
        this.handleDyeableIngredientItem(LOTRItemHobbitPipe.class, ingredient, stack -> LOTRItemHobbitPipe.getSmokeColor(stack) != 0, LOTRItemHobbitPipe::removePipeDye, recipes);
        this.handleDyeableIngredientItem(LOTRItemLeatherHat.class, ingredient, ((Predicate<ItemStack>)LOTRItemLeatherHat::isHatDyed).or(LOTRItemLeatherHat::isFeatherDyed), LOTRItemLeatherHat::removeHatAndFeatherDye, recipes);
        this.handleDyeableIngredientItem(LOTRItemFeatherDyed.class, ingredient, LOTRItemFeatherDyed::isFeatherDyed, LOTRItemFeatherDyed::removeFeatherDye, recipes);
        this.handleDyeableIngredientItem(LOTRItemHaradRobes.class, ingredient, LOTRItemHaradRobes::areRobesDyed, LOTRItemHaradRobes::removeRobeDye, recipes);
        this.handleDyeableIngredientItem(LOTRItemPartyHat.class, ingredient, LOTRItemPartyHat::isHatDyed, LOTRItemPartyHat::removeHatDye, recipes);
        if (ingredient.func_77973_b() instanceof ItemArmor) {
            ItemArmor armorItem = (ItemArmor)ingredient.func_77973_b();
            this.handleDyeableIngredientItem(ItemArmor.class, ingredient, arg_0 -> ((ItemArmor)armorItem).func_82816_b_(arg_0), arg_0 -> ((ItemArmor)armorItem).func_82815_c(arg_0), recipes);
        }
        if (LOTRRecipePoisonWeapon.poisonedToInput.containsKey(ingredient.func_77973_b())) {
            ItemStack result = new ItemStack(LOTRRecipePoisonWeapon.poisonedToInput.get(ingredient.func_77973_b()));
            if (ingredient.func_77984_f()) {
                result.func_77964_b(ingredient.func_77960_j());
            }
            recipes.add(new ShapelessRecipe((Object)ingredient, result));
        }
        return recipes;
    }

    private <T extends Item> void handleDyeableIngredientItem(Class<T> itemType, ItemStack ingredient, Predicate<ItemStack> isDyedFunction, Consumer<ItemStack> removeDyeFunction, Collection<ShapelessRecipe> recipes) {
        if (itemType.isAssignableFrom(ingredient.func_77973_b().getClass()) && isDyedFunction.test(ingredient)) {
            ItemStack resultStack = ingredient.func_77946_l();
            removeDyeFunction.accept(resultStack);
            recipes.add(new ShapelessRecipe((Object)ingredient, resultStack));
        }
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(ShapelessRecipe recipe, EnumRecipeItemRole role) {
        return Arrays.asList(role == EnumRecipeItemRole.INGREDIENT ? this.createRecipeItemSlot(43, 24) : this.createRecipeItemSlot(101, 24));
    }

    public CauldronRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public int getDefaultOrder() {
        return 9000;
    }

    public class CauldronRecipeHandlerRenderer
    implements RecipeHandlerRenderer<CauldronRecipeHandler, ShapelessRecipe> {
        public void renderBackground(CauldronRecipeHandler handler, ShapelessRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("textures/gui/container/crafting_table.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(42, 19, 65, 30, 80, 26);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(42, 13, 18, 10, -3750202);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(42, 41, 18, 4, -3750202);
        }

        public void renderForeground(CauldronRecipeHandler handler, ShapelessRecipe recipe, int cycleticks) {
        }
    }

    public class UndyeningRecipe
    extends ShapelessRecipe {
        public UndyeningRecipe(Collection<ItemStack> ingredients, ItemStack result) {
            super(Arrays.asList(new Object[0]), result);
            this.ingredients.add(this.createItemStackSet(ingredients));
        }

        protected ItemStackSet createItemStackSet(ItemStack ... stacks) {
            return ItemStackSet.create((boolean)true, (ItemStack[])stacks);
        }

        protected ItemStackSet createItemStackSet(Collection<ItemStack> stacks) {
            return ItemStackSet.create((boolean)true, stacks);
        }

        public ItemStack getResultReplacement(ItemStack defaultReplacement) {
            return defaultReplacement;
        }
    }
}

